<?php
namespace FacturaScripts\Plugins\AgentesComerciales\Extension\Model;

use Closure;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class PagoCliente
{
    public function saveInsert(): Closure
    {
        return function() {
            // Después de que se genere el asiento normal, verificar si es fraccionado
            if (!empty($this->idasiento)) {
                $recibo = $this->getReceipt();
                
                // Verificar si es recibo fraccionado
                if ($recibo && $recibo->exists()) {
                    $formaPago = new \FacturaScripts\Dinamic\Model\FormaPago();
                    if ($formaPago->loadFromCode($recibo->codpago)) {
                        $descripcion = strtolower($formaPago->descripcion);
                        $esFraccionado = (strpos($descripcion, '30,60,90') !== false || 
                                        strpos($descripcion, '30-60-90') !== false);
                        
                        if ($esFraccionado) {
                            $this->modificarAsientoPago($recibo);
                        }
                    }
                }
            }
            
            return true;
        };
    }
    
    public function modificarAsientoPago(): Closure
    {
        return function($recibo) {
            // Buscar la partida con subcuenta 430 en este asiento
            $partida = new \FacturaScripts\Dinamic\Model\Partida();
            $where = [
                new DataBaseWhere('idasiento', $this->idasiento),
                new DataBaseWhere('codsubcuenta', '4300', 'LIKE')
            ];
            
            $partidas = $partida->all($where, [], 0, 1);
            if (empty($partidas)) {
                return;
            }
            
            $partida430 = $partidas[0];
            
            // Obtener cliente para generar código 431
            $cliente = new \FacturaScripts\Dinamic\Model\Cliente();
            if (!$cliente->loadFromCode($recibo->codcliente) || empty($cliente->cifnif)) {
                return;
            }
            
            // Generar código de subcuenta 431
            $soloNumeros = preg_replace('/[^0-9]/', '', $cliente->cifnif);
            $ultimosDigitos = str_pad(substr($soloNumeros, -4), 4, '0', STR_PAD_LEFT);
            $codigo431 = '431000' . $ultimosDigitos;
            
            // Buscar la subcuenta 431
            $subcuenta = new \FacturaScripts\Dinamic\Model\Subcuenta();
            $where431 = [
                new DataBaseWhere('codsubcuenta', $codigo431),
                new DataBaseWhere('codejercicio', $recibo->codejercicio ?? date('Y'))
            ];
            
            $subcuentas = $subcuenta->all($where431, [], 0, 1);
            if (empty($subcuentas)) {
                return;
            }
            
            $subcuenta431 = $subcuentas[0];
            
            // Modificar la partida para usar la subcuenta 431
            $partida430->codsubcuenta = $subcuenta431->codsubcuenta;
            $partida430->idsubcuenta = $subcuenta431->idsubcuenta;
            $partida430->save();
        };
    }
}