<?php
namespace FacturaScripts\Plugins\AgentesComerciales\Extension\Model;
use Closure;

class FacturaCliente
{
    public function save(): Closure
    {
        return function() {
            $result = parent::save();
            
            // Solo procesar facturas nuevas no pagadas
            if ($result && $this->idfactura && !$this->pagada) {
                // Usar un callback diferido para ejecutar después del proceso completo
                register_shutdown_function([$this, 'procesarFraccionamientoAutomatico']);
            }
            
            return $result;
        };
    }

    public function procesarFraccionamientoAutomatico(): void
    {
        // Esperar a que se complete todo el proceso de guardado
        sleep(2);
        
        // Recargar la factura para tener datos completos
        $factura = new \FacturaScripts\Dinamic\Model\FacturaCliente();
        if (!$factura->loadFromCode($this->idfactura)) {
            return;
        }
        
        // Solo facturas no pagadas con exactamente 1 recibo
        $recibos = $factura->getReceipts();
        if ($factura->pagada || count($recibos) !== 1) {
            return;
        }
        
        // Verificar si requiere fraccionamiento
        $formaPago = new \FacturaScripts\Dinamic\Model\FormaPago();
        if (!$formaPago->loadFromCode($factura->codpago)) {
            return;
        }
        
        $descripcion = strtolower($formaPago->descripcion);
        if (strpos($descripcion, '30,60,90') === false && strpos($descripcion, '30-60-90') === false) {
            return;
        }
        
        // Eliminar recibo único existente
        foreach ($recibos as $recibo) {
            $recibo->delete();
        }
        
        // Crear 3 recibos fraccionados usando la misma lógica del botón
        $this->crearRecibosFraccionados($factura);
    }

    private function crearRecibosFraccionados($factura): void
    {
        $diasVencimiento = [30, 60, 90];
        $importeRecibo = round($factura->total / 3, 2);
        $importeUltimo = $factura->total - ($importeRecibo * 2);
        
        foreach ($diasVencimiento as $index => $dias) {
            $recibo = new \FacturaScripts\Dinamic\Model\ReciboCliente();
            
            $recibo->codcliente = $factura->codcliente;
            $recibo->coddivisa = $factura->coddivisa;
            $recibo->codigofactura = $factura->codigo;
            $recibo->codpago = $factura->codpago;
            $recibo->fecha = $factura->fecha;
            $recibo->idempresa = $factura->idempresa;
            $recibo->idfactura = $factura->idfactura;
            $recibo->nick = $factura->nick;
            $recibo->importe = ($index === 2) ? $importeUltimo : $importeRecibo;
            
            $fechaVencimiento = new \DateTime($factura->fecha);
            $fechaVencimiento->add(new \DateInterval("P{$dias}D"));
            $recibo->vencimiento = $fechaVencimiento->format('Y-m-d');
            
            $recibo->numero = $this->getSiguienteNumero($factura->idempresa);
            $recibo->pagado = false;
            $recibo->observaciones = "Recibo " . ($index + 1) . "/3 - {$dias} días";
            
            $recibo->save();
        }
    }

    private function getSiguienteNumero($idempresa): int
    {
        $db = new \FacturaScripts\Core\Base\DataBase();
        $sql = "SELECT COALESCE(MAX(numero), 0) + 1 as num FROM recibospagoscli WHERE idempresa = " . (int)$idempresa;
        $data = $db->select($sql);
        return empty($data) ? 1 : (int)$data[0]['num'];
    }
}