<?php
/**
 * This file is part of AgentesComerciales plugin for FacturaScripts
 * Copyright (C) 2022-2024 Carlos Garcia Gomez <carlos@facturascripts.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

namespace FacturaScripts\Plugins\AgentesComerciales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;

/**
 * Description of EditServicioATLog
 *
 * @author Carlos Garcia Gomez <carlos@facturascripts.com>
 */
class EditServicioATLog extends EditController
{
    public function getModelClassName(): string
    {
        return 'ServicioATLog';
    }

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data['menu'] = 'Agentes';
        $data['title'] = 'history';
        $data['icon'] = 'fa-solid fa-history';
        $data['showonmenu'] = false;
        return $data;
    }

    protected function createViews()
    {
        parent::createViews();
        $this->setSettings($this->getMainViewName(), 'btnNew', false);
    }
}
